/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task.forge;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.FluidConfig;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import java.util.Optional;
import javax.annotation.Nullable;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.architectury.hooks.FluidStackHooks;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.utils.Fraction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ForgeFluidTask
extends Task {
    public static TaskType TYPE;
    public static final ResourceLocation TANK_TEXTURE;
    public Fluid fluid = Fluids.field_204546_a;
    public CompoundNBT fluidNBT = null;
    public long amount = FluidStack.bucketAmount().longValue();
    private FluidStack cachedFluidStack = null;

    public ForgeFluidTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TYPE;
    }

    @Override
    public long getMaxProgress() {
        return this.amount;
    }

    @Override
    public String formatMaxProgress() {
        return ForgeFluidTask.getVolumeString(this.amount);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return ForgeFluidTask.getVolumeString((int)Math.min(Integer.MAX_VALUE, progress));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    public void writeData(CompoundNBT nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("fluid", Registries.getId((Object)this.fluid, (RegistryKey)Registry.field_239709_j_).toString());
        nbt.func_74772_a("amount", this.amount);
        if (this.fluidNBT != null) {
            nbt.func_218657_a("nbt", (INBT)this.fluidNBT);
        }
    }

    @Override
    public void readData(CompoundNBT nbt) {
        super.readData(nbt);
        this.fluid = (Fluid)Registry.field_212619_h.func_82594_a(new ResourceLocation(nbt.func_74779_i("fluid")));
        if (this.fluid == null || this.fluid == Fluids.field_204541_a) {
            this.fluid = Fluids.field_204546_a;
        }
        this.amount = Math.max(1L, nbt.func_74763_f("amount"));
        this.fluidNBT = (CompoundNBT)nbt.func_74781_a("nbt");
    }

    @Override
    public void writeNetData(PacketBuffer buffer) {
        super.writeNetData(buffer);
        buffer.func_192572_a(Registries.getId((Object)this.fluid, (RegistryKey)Registry.field_239709_j_));
        buffer.func_150786_a(this.fluidNBT);
        buffer.func_179254_b(this.amount);
    }

    @Override
    public void readNetData(PacketBuffer buffer) {
        super.readNetData(buffer);
        this.fluid = (Fluid)Registry.field_212619_h.func_82594_a(buffer.func_192575_l());
        if (this.fluid == null || this.fluid == Fluids.field_204541_a) {
            this.fluid = Fluids.field_204546_a;
        }
        this.fluidNBT = buffer.func_150793_b();
        this.amount = buffer.func_179260_f();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedFluidStack = null;
    }

    public FluidStack createFluidStack() {
        if (this.cachedFluidStack == null) {
            this.cachedFluidStack = FluidStack.create((Fluid)this.fluid, (Fraction)FluidStack.bucketAmount(), (CompoundNBT)this.fluidNBT);
        }
        return this.cachedFluidStack;
    }

    public static String getVolumeString(long a) {
        StringBuilder builder = new StringBuilder();
        if (a >= FluidStack.bucketAmount().longValue()) {
            if (a % FluidStack.bucketAmount().longValue() != 0L) {
                builder.append((double)a / (double)FluidStack.bucketAmount().longValue());
            } else {
                builder.append(a / FluidStack.bucketAmount().longValue());
            }
        } else {
            builder.append(a % FluidStack.bucketAmount().longValue());
        }
        builder.append(' ');
        if (a < FluidStack.bucketAmount().longValue()) {
            builder.append('m');
        }
        builder.append('B');
        return builder.toString();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IFormattableTextComponent getAltTitle() {
        return new StringTextComponent(ForgeFluidTask.getVolumeString(this.amount) + " of ").func_230529_a_(this.createFluidStack().getName());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        FluidStack stack = this.createFluidStack();
        return Icon.getIcon((String)Optional.ofNullable(FluidStackHooks.getStillTexture((FluidStack)stack)).map(TextureAtlasSprite::func_195668_m).map(ResourceLocation::toString).orElse("missingno"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.add("fluid", (ConfigValue)new FluidConfig(false), (Object)this.fluid, v -> {
            this.fluid = v;
        }, (Object)Fluids.field_204546_a);
        config.add("fluid_nbt", (ConfigValue)new NBTConfig(), (Object)this.fluidNBT, v -> {
            this.fluidNBT = v;
        }, null);
        config.addLong("amount", this.amount, v -> {
            this.amount = v;
        }, FluidStack.bucketAmount().longValue(), 1L, Long.MAX_VALUE);
    }

    @Override
    public boolean canInsertItem() {
        return true;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public Object getIngredient() {
        return this.createFluidStack();
    }

    static {
        TANK_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/tank.png");
    }
}

